<?php
/**
 * Extra functions for theme
 * @package ninja
 */

// Mark Posts/Pages as Untiled when no title is used
function ninja_title( $title ) {
	if ( $title == '' ) {
		return 'Untitled';
	} else {
		return $title;
	}
}
add_filter( 'the_title', 'ninja_title' );

/**
 * Custom header image @ HEADER LOGO
 */
function ninja_custom_header_setup() {
	add_theme_support( 'custom-header', apply_filters( 'ninja_custom_header_args', array(
		'default-image'			=> '',
		'default-text-color'	=> '000',
		'width'					=> 165,
		'height'				=> 90,
		'flex-height'			=> true,
		'flex-width'			=> true,
		//'wp-head-callback'		=> 'sparkling_header_style',
		//'admin-head-callback'	=> 'sparkling_admin_header_style',
		//'admin-preview-callback'=> 'sparkling_admin_header_image',
	) ) );
}
add_action( 'after_setup_theme', 'ninja_custom_header_setup' );

/**
 * Customize the PageNavi HTML before it is output to support bootstrap
 */
function ninja_wp_pagenavi_bootstrap_markup( $html ) {
	$out = '';

	//wrap a's and span's in li's
	$out = str_replace( "<div", "", $html );
	$out = str_replace( "class='wp-pagenavi'>", "", $out );
	$out = str_replace( "<a", "<li><a", $out );
	$out = str_replace( "</a>", "</a></li>", $out );
	$out = str_replace( "<span", "<li><span", $out );
	$out = str_replace( "</span>", "</span></li>", $out );
	$out = str_replace( "</div>", "", $out );

	return '<div class="navigation text-center"><ul class="pagination pagination-centered wp-pagenavi-pagination">' . $out . '</ul></div>';
}
add_filter( 'wp_pagenavi', 'ninja_wp_pagenavi_bootstrap_markup' );

// Add Bootstrap classes for table
function ninja_add_bootstrap_table_class( $content ) {
	return preg_replace( '/(<table) ?(([^>]*)class="([^"]*)")?/', '$1 $3 class="$4 table table-hover" ', $content);
}
add_filter( 'the_content', 'ninja_add_bootstrap_table_class' );

/**
 * Add Bootstrap thumbnail styling to images with captions
 * Use <figure> and <figcaption>
 *
 * @link http://justintadlock.com/archives/2011/07/01/captions-in-wordpress
 */
function ninja_bootstrap_caption($output, $attr, $content) {
  if (is_feed()) {
    return $output;
  }

  $defaults = array(
    'id'      => '',
    'align'   => 'alignnone',
    'width'   => '',
    'caption' => ''
  );

  $attr = shortcode_atts($defaults, $attr);

  // If the width is less than 1 or there is no caption, return the content wrapped between the [caption] tags
  if ($attr['width'] < 1 || empty($attr['caption'])) {
    return $content;
  }

  // Set up the attributes for the caption <figure>
  $attributes  = (!empty($attr['id']) ? ' id="' . esc_attr($attr['id']) . '"' : '' );
  $attributes .= ' class="thumbnail wp-caption ' . esc_attr($attr['align']) . '"';
  $attributes .= ' style="width: ' . (esc_attr($attr['width']) + 10) . 'px"';

  $output  = '<figure' . $attributes .'>';
  $output .= do_shortcode($content);
  $output .= '<figcaption class="caption wp-caption-text">' . $attr['caption'] . '</figcaption>';
  $output .= '</figure>';

  return $output;
}
add_filter('img_caption_shortcode', 'ninja_bootstrap_caption', 10, 3);