<?php
/**
 * The default single page template.
 * @package ninja
 */

get_header(); ?>

<div id="primary" class="content-area">

	<main id="main" class="site-main" role="main">

	<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>

		<div id="container">
		        
        	<?php do_action('ninja_breadcrumbs'); ?>

			<div class="content content-with-sidebar col-md-9 col-md-push-3">
				<h1><?php the_title(); ?></h1>

				<?php 
		          if ( has_post_thumbnail() ) { // check if the post has a Post Thumbnail assigned to it.
		            $thumb_id = get_post_thumbnail_id();
		            $thumb_url_array = wp_get_attachment_image_src($thumb_id, 'thumbnail-size', true);
		            $thumb_url = $thumb_url_array[0];
		            echo '<img src="'.$thumb_url.'"/>';
		          } 
		        ?>
				<?php the_content(); ?>
			</div><!-- .content -->

			<div class="sidebar col-md-3 col-md-pull-9">
          		<?php get_sidebar(); ?>
          	</div>

		</div><!-- #container -->

	<?php endwhile; else : ?>
		<p><?php _e( 'Sorry, there is nothing here. Perhaps searching might help.' ); ?></p>
		<?php get_search_form(); ?>
	<?php endif; ?>
	
	</main>
</div>
<?php get_footer(); ?>