<?php

// Prevent direct file access
if( ! defined( 'SCCSS_FILE' ) ) {
	die();
}

/**
* Print direct link to Custom CSS admin page
*
* Fetches array of links generated by WP Plugin admin page ( Deactivate | Edit )
* and inserts a link to the Custom CSS admin page
*
* @since  1.0
* @param  array $links Array of links generated by WP in Plugin Admin page.
* @return array        Array of links to be output on Plugin Admin page.
*/
function sccss_settings_link( $links ) {
	return array_merge(
		array(
			'settings' => '<a href="' . admin_url( 'themes.php?page=simple-custom-css.php' ) . '">' . __( 'Add CSS', 'simple-custom-css' ) . '</a>'
		),
		$links
	);
}
add_filter( 'plugin_action_links_' . plugin_basename( SCCSS_FILE ), 'sccss_settings_link' );


/**
* Register text domain
*
* @since 1.0
*/
function sccss_textdomain() {
	load_plugin_textdomain( 'simple-custom-css', false, dirname( plugin_basename( SCCSS_FILE ) ) . '/languages/' );
}
add_action( 'plugins_loaded', 'sccss_textdomain' );


/**
* Delete Options on Uninstall
*
* @since 1.1
*/
function sccss_uninstall() {
	delete_option( 'sccss_settings' );
}
register_uninstall_hook( SCCSS_FILE, 'sccss_uninstall' );


/**
 * Enqueues Scripts/Styles for Syntax Highlighter
 *
 * @since  3.0
 * @param  string  Hook of admin screen
 * @return void
 */
function sccss_register_codemirror( $hook ) {
	if ( 'appearance_page_simple-custom-css' === $hook ) {
		wp_enqueue_style( 'codemirror-css', plugins_url( 'simple-custom-css/codemirror/codemirror.css' ) );
		wp_enqueue_script( 'codemirror-js', plugins_url( 'simple-custom-css/codemirror/codemirror.js' ), array(), '20140329', true );
		wp_enqueue_script( 'codemirror-css-js', plugins_url( 'simple-custom-css/codemirror/css.js' ), array(), '20140329', true );
	}
}
add_action( 'admin_enqueue_scripts', 'sccss_register_codemirror' );


/**
 * Register "Custom CSS" submenu in "Appearance" Admin Menu
 *
 * @since 1.0
 */
function sccss_register_submenu_page() {
	add_theme_page( __( 'Simple Custom CSS', 'simple-custom-css' ), __( 'Custom CSS', 'simple-custom-css' ), 'edit_theme_options', basename( SCCSS_FILE ), 'sccss_render_submenu_page' );
}
add_action( 'admin_menu', 'sccss_register_submenu_page' );


/**
 * Register settings
 *
 * @since 1.0
 */
function sccss_register_settings() {
	register_setting( 'sccss_settings_group', 'sccss_settings' );
}
add_action( 'admin_init', 'sccss_register_settings' );


/**
 * Render Admin Menu page
 *
 * @since 1.0
 */
function sccss_render_submenu_page() {

	$options = get_option( 'sccss_settings' );
	$content = isset( $options['sccss-content'] ) && ! empty( $options['sccss-content'] ) ? $options['sccss-content'] : __( '/* Enter Your Custom CSS Here */', 'simple-custom-css' );

	if ( isset( $_GET['settings-updated'] ) ) : ?>
		<div id="message" class="updated"><p><?php _e( 'Custom CSS updated successfully.', 'simple-custom-css' ); ?></p></div>
	<?php endif; ?>
	<div class="wrap">
		<h2 style="margin-bottom: 1em;"><?php _e( 'Simple Custom CSS', 'simple-custom-css' ); ?></h2>
		<form name="sccss-form" action="options.php" method="post" enctype="multipart/form-data">
			<?php settings_fields( 'sccss_settings_group' ); ?>
			<div id="templateside">
				<?php do_action( 'sccss-sidebar-top' ); ?>
				<p style="margin-top: 0"><?php _e( 'Simple Custom CSS allows you to add your own styles or override the default CSS of a plugin or theme.', 'simple-custom-css' ) ?></p>
				<p><?php _e( 'To use, enter your custom CSS, then click "Update Custom CSS".  It\'s that simple!', 'simple-custom-css' ) ?></p>
				<?php submit_button( __( 'Update Custom CSS', 'simple-custom-css' ), 'primary', 'submit', true ); ?>
				<?php do_action( 'sccss-sidebar-bottom' ); ?>
			</div>
			<div id="template">
				<?php do_action( 'sccss-form-top' ); ?>
				<div>
					<textarea cols="70" rows="30" name="sccss_settings[sccss-content]" id="sccss_settings[sccss-content]" ><?php echo esc_html( $content ); ?></textarea>
				</div>
				<?php do_action( 'sccss-textarea-bottom' ); ?>
				<div>
					<?php submit_button( __( 'Update Custom CSS', 'simple-custom-css' ), 'primary', 'submit', true ); ?>
				</div>
				<?php do_action( 'sccss-form-bottom' ); ?>
			</div>
		</form>
		<script language="javascript">
			jQuery( document ).ready( function() {
				var editor = CodeMirror.fromTextArea( document.getElementById( "sccss_settings[sccss-content]" ), {lineNumbers: true, lineWrapping: true} );
			});
		</script>
	</div>
<?php
}
