<?php
/**
 * The Template for displaying all single posts.
 *
 * @package sparkling
 */

get_header(); ?>

	<div id="primary" class="content-area single-news-page my-product-main">
		<main id="main" class="site-main" role="main">

		<?php while ( have_posts() ) : the_post(); ?>

			<div class="container">
	          <div class="row">
	            <div class="breadcrumbs">
	              <?php if(function_exists('bcn_display'))
	              {
	                bcn_display();
	              }?>
	            </div>
	          </div>
	        </div>

			<?php //get_template_part( 'content', 'single-product' ); ?>

			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				<div class="post-inner-content">
					<div class="container">
						<section class="custom-product-container custom-category-list">
							<div class="page-left my-new-left">
								<h3>News Release</h3>
								<h6>view by category</h6>
								<?php 
									echo do_shortcode ('[wpb_category_accordion taxonomy="news-type" orderby="id" order="ASC" show_count="no" hide_empty="no"]');
								 ?>
								<div style="height: 50px; clear:both;"></div>
							</div>

							<div class="right-content my-single-new-content">
								<h1 class="my-page-title">
									<span class="my-title">News Release</span>
									<span class="my-deco"></span>
								</h1>

								<div class="single-post-date"><?php echo get_the_date('d.n.Y');?></div>

								<h3><?php the_title(); ?></h3>

								<?php
									the_content();
								?>

								<p class="return-back"><a href="<?php get_template_directory_uri()?>/news"><i class="fa fa-angle-double-left" aria-hidden="true"></i> Back</a></p>

							</div>

						</section>
					</div>
				</div>
			</article>

			<?php
				// If comments are open or we have at least one comment, load up the comment template
				if ( comments_open() || '0' != get_comments_number() ) :
					comments_template();
				endif;
			?>

			<?php sparkling_post_nav(); ?>

		<?php endwhile; // end of the loop. ?>

		</main><!-- #main -->
	</div><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>