<?php
    defined( 'ABSPATH' ) || exit;

/**
 * Enqueue scripts and styles.
 */
function ninja_scripts() {

    // Load jquery
    wp_enqueue_script('jquery');
    
    // Bootstrap default CSS
    wp_enqueue_style( 'ninja-bootstrap', get_template_directory_uri() . '/inc/css/bootstrap.min.css', array(), '220718' );
  
    // Font Awesome
    wp_enqueue_style( 'ninja-icons', '//use.fontawesome.com/releases/v6.1.1/css/all.css' );
  
    // Google Fonts
    wp_enqueue_style( 'ninja-fonts', '//fonts.googleapis.com/css2?family=Noto+Sans+SC:wght@400;900&display=swap');
  
    // Main theme stylesheet
    wp_enqueue_style( 'ninja-style', get_stylesheet_uri() );
  
    // Custom style
    wp_enqueue_style( 'ninja-custom-style', get_template_directory_uri().'/custom.css' );
  
    // Responsive style
    wp_enqueue_style( 'ninja-responsive-style', get_template_directory_uri().'/responsive.css' );

    // Slick Carousel Js
    wp_enqueue_script( 'slick-js', get_template_directory_uri() . '/slick/slick.min.js', array('jquery'), '', true );

    // Slick Carousel Css
    wp_enqueue_style( 'slick-css', get_template_directory_uri().'/slick/slick.css', '', true );

    // Slick Carousel Theme
    wp_enqueue_style( 'slick-theme', get_template_directory_uri().'/slick/slick-theme.css' );
  
    // Accordion script
    wp_enqueue_script( 'accordion-script', get_stylesheet_directory_uri() . '/js/jquery.navgoco.min.js', array('jquery'), '', true );
  
    // Main theme related functions
    wp_enqueue_script( 'ninja-functions', get_template_directory_uri() . '/inc/js/scrollTopPage.js', array('jquery'), '', true );
  
    // Smooth scroll script
    wp_enqueue_script( 'smooth-scroll-script', get_template_directory_uri() . '/inc/js/smooth.scroll.js', array('jquery'), '', true );
  
    // Custom scripts
    if ( is_page_template('page-thankyou.php') ) {
      wp_enqueue_script( 'thank-you-script', get_template_directory_uri() . '/js/tqcountdown.js', array('jquery') ,'1.', true);
    }
    //wp_enqueue_script( 'parallax-script', get_template_directory_uri() . '/js/parallax.js', array('jquery') );
    wp_enqueue_script( 'custom-script', get_template_directory_uri() . '/js/custom.js', array('jquery'), '', true );
  
}
add_action( 'wp_enqueue_scripts', 'ninja_scripts' );

if ( ! isset( $content_width ) ) { $content_width = 648; /* pixels */ }

/**
 * Set the content width for full width pages with no sidebar.
 */
function ninja_content_width() {
  if ( is_page_template( 'page-fullwidth.php' ) ) {
    global $content_width;
    $content_width = 1008; /* pixels */
  }
}
add_action( 'template_redirect', 'ninja_content_width' );

/**
 * Set container based on template
 */
function set_ninja_container(){
    $container = [];
    $templates = [];

    $templates = ['page-fullwidth.php', 'page-home.php'];

    if ( is_page_template($templates) ) {
        $container['container_type'] = 'container-fluid';
    }else{
        $container['container_type'] = 'container';
    }

    return $container;
}

function ninja_container(){
    $container = set_ninja_container();
    $ninja_container = $container['container_type'];
    return $ninja_container;
}

/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
if ( ! function_exists( 'ninja_setup' ) ) :
    function ninja_setup() {
        // Make theme available for translation. Translations can be filed in the /languages/ directory.
        //load_theme_textdomain( 'ninja', get_template_directory() . '/languages' );

        // Enable support for Post Thumbnails on posts and pages.
        add_theme_support( 'post-thumbnails' );
        // This theme uses wp_nav_menu() in one location.
        register_nav_menus( 
            array(
            'primary'      => esc_html__( 'Primary Menu', 'ninja' ),
            'social-menu'  => esc_html__( 'Social Menu', 'ninja' ),
            ) 
        );
        // Enable support for HTML5 markup.
        add_theme_support( 'html5', array(
            'search-form',
            'gallery',
            'caption'
        ) );
        // Let WordPress manage the document title in the document head.
        add_theme_support( 'title-tag' );
        // Enable support for WooCommerce.
        add_theme_support( 'woocommerce' );


        // Add theme support for Custom Logo.
        add_theme_support(
            'custom-logo',
            array(
                'width'      => 220,
                'height'     => 125,
                'flex-width' => true,
            )
        );
        
    }
endif; // ninja_setup
add_action( 'after_setup_theme', 'ninja_setup' );

/**
 * Register widgetized area and update sidebar with default widgets.
 */
function ninja_widgets_init() {

    register_sidebar( array(
        'id'            => 'sidebar-widget',
        'name'          => esc_html__( 'Sidebar', 'ninja' ),
        'description'   => esc_html__( 'The default sidebar widget', 'ninja' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ) );

    register_sidebar( array(
        'id'            => 'header-widget',
        'name'          => esc_html__( 'Header Widget Area', 'ninja' ),
        'description'   => esc_html__( 'The header widget area', 'ninja' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ) );

    register_sidebar( array(
        'id'            => 'footer-widget',
        'name'          => esc_html__( 'Footer Widget Area', 'ninja' ),
        'description'   => esc_html__( 'The footer widget area', 'ninja' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ) );

     register_sidebar( array(
        'id'            => 'floating-widget',
        'name'          => esc_html__( 'Floating Widget', 'ninja' ),
        'description'   => esc_html__( 'Floating Widget', 'ninja' ),
        'before_widget' => '<div id="%1$s" class="floating widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
     ) );

    register_sidebar( array(
        'id'            => 'product-sidebar-widget',
        'name'          => esc_html__( 'Product Sidebar', 'ninja' ),
        'description'   => esc_html__( 'The product sidebar widget', 'ninja' ),
        'before_widget' => '<aside id="%1$s" class="widget %2$s">',
        'after_widget'  => '</aside>',
        'before_title'  => '<h3 class="widgettitle">',
        'after_title'   => '</h3>',
    ) );

    register_widget( 'ninja_social_widget' );
}
add_action( 'widgets_init', 'ninja_widgets_init' );

/**
 * Theme Widgets
 */
require_once(get_template_directory() . '/inc/widget-social.php');
//if( function_exists( 'elementor_load_plugin_textdomain' ) ) {require_once('custom-widgets/my-widgets.php');}

/**
 * Unregister all unnecessary widgets 
 */
function ninja_unregister_default_widgets() {
    unregister_widget('WP_Widget_Pages');
    unregister_widget('WP_Widget_Calendar');
    unregister_widget('WP_Widget_Links');
    unregister_widget('WP_Widget_Meta');
    unregister_widget('WP_Widget_Recent_Comments');
    unregister_widget('WP_Widget_Recent_Posts');
    unregister_widget('WP_Widget_RSS');
    unregister_widget('WP_Widget_Tag_Cloud');

    // WOO WIDGETS
    unregister_widget( 'WC_Widget_Layered_Nav' );
    unregister_widget( 'WC_Widget_Layered_Nav_Filters' );
    unregister_widget( 'WC_Widget_Price_Filter' );
    unregister_widget( 'WC_Widget_Product_Tag_Cloud' );
    unregister_widget( 'WC_Widget_Recent_Reviews' );
    unregister_widget( 'WC_Widget_Recently_Viewed' );
    unregister_widget( 'WC_Widget_Top_Rated_Products' );
} 
add_action('widgets_init', 'ninja_unregister_default_widgets', 11);

/**
 * This function removes inline styles set by WordPress gallery.
 */
function ninja_remove_gallery_css( $css ) {
  return preg_replace( "#<style type='text/css'>(.*?)</style>#s", '', $css );
}
add_filter( 'gallery_style', 'ninja_remove_gallery_css' );

function woocommerce_styling(){
    wp_enqueue_style( 'woocommerce-style', get_template_directory_uri().'/woocommerce/woocommerce.css' );
}

if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    add_action( 'wp_enqueue_scripts', 'woocommerce_styling' );
    require get_template_directory() . '/woocommerce/woo-functions.php';
}

/**
 * Extra functions for this theme.
 */
require get_parent_theme_file_path() . '/inc/navwalker.php'; // CUSTOM NAV WALKER
require get_parent_theme_file_path() . '/inc/navigation.php'; // NAVIGATION RELATED FUNCTIONS
require get_parent_theme_file_path() . '/inc/extras.php'; // THEME RELATED FUNCTIONS

/**
 * Default Excerpt Length
 */
function ninja_excerpt_length( $length ) {
    return 25;
}
add_filter( 'excerpt_length', 'ninja_excerpt_length', 999 );

/**
 * Shortcodes in excerpt and widgets
 */
add_filter('the_excerpt', 'do_shortcode');
add_filter('widget_text','do_shortcode');

/**
 * Allow shortcodes inside Contact Form 7 forms
 */
function shortcode_wpcf7_form( $form ) {
    $form = do_shortcode( $form );
    return $form;
}
add_filter( 'wpcf7_form_elements', 'shortcode_wpcf7_form' );

/**
 * Create layout for ninja breadcrumbs
 */
function ninja_breadcrumbs(){

    if ( function_exists('bcn_display') ){
        $output = '';
        $output .= '<!--start breadcrumbs--><div class="breadcrumbs">';

        $container = set_ninja_container();
        $ninja_container = $container['container_type'];
        $breadcrumbs = bcn_display(true, true, false);

        if ( $ninja_container == 'container-fluid' ){
            $output .= '<div class="container"><div class="row"><div class="col-sm-12">';
            $output .= $breadcrumbs;
            $output .= '</div></div></div>';
        }else{
            $output .= $breadcrumbs;
        }
        
        $output .= '</div><!--end breadcrumbs-->';
        echo $output;
    }

}
add_action( 'ninja_breadcrumbs', 'ninja_breadcrumbs');

/**
 * Set pagenavi plugin as default navigation
 */
function ninja_navigation(){
    if ( function_exists('wp_pagenavi') ) { wp_pagenavi(); }
}
add_action( 'ninja_navigation', 'ninja_navigation');

/**
 * Remove archive type from title
 */
add_filter( 'get_the_archive_title', 'remove_prefix_archive_title' );
function remove_prefix_archive_title ($title) {
    if ( is_category() ) {
        $title = single_cat_title( '', false );
    } elseif ( is_tag() ) {
        $title = single_tag_title( '', false );
    } elseif ( is_author() ) {
        $title = '<span class="vcard">' . get_the_author() . '</span>' ;
    } elseif ( is_tax() ){
        $title = single_term_title( '', false );
    } elseif ( is_post_type_archive() ){
        $title = post_type_archive_title( '', false );
    }
    return $title;
}

/* Hide WP version strings from scripts and styles
* @return {string} $src
* @filter script_loader_src
* @filter style_loader_src
*/
function ninja_remove_wp_version_strings( $src ) {
    global $wp_version;
    parse_str(parse_url($src, PHP_URL_QUERY), $query);
    if ( !empty($query['ver']) && $query['ver'] === $wp_version ) {
        $src = remove_query_arg('ver', $src);
    }
    return $src;
}
add_filter( 'script_loader_src', 'ninja_remove_wp_version_strings' );
add_filter( 'style_loader_src', 'ninja_remove_wp_version_strings' );

/* Hide WP version strings from generator meta tag */
function ninja_remove_version() {
    return '';
}
add_filter('the_generator', 'ninja_remove_version');

/**
 * Grab all Toolset Types Custom Fields by Group ID or Group Slug
 */
function types_render_group($target_group) {
    global $post;
    require_once WPCF_EMBEDDED_INC_ABSPATH . '/fields.php';
     
    //by known group_id
    if(is_numeric($target_group)){
        return wpcf_admin_fields_get_fields_by_group($target_group);
    }
    //by known slug
    else{
        $groups = wpcf_admin_fields_get_groups();
        foreach($groups AS $group){
            if($group['slug'] == $target_group){
                return wpcf_admin_fields_get_fields_by_group($group['id']);
            }
        }
    }
    //check yourself, dude
    return false;
}


/** 
 *
 * @shortcode [floating-btn] 
 * @return string - widget or custom Html for the floating CTA button
 * @use - in wp_dasboard > appearance > Widgets > "Floating Widget" apply any custom HTML or widget to display on floating section.  
 *  
 */
add_shortcode( 'floating-btn', 'floating_btn' );
function floating_btn(){ do_shortcode(dynamic_sidebar("floating-widget")); }

/** 
 *
 * @shortcode [product-sidebar] 
 * @return string - widget or custom Html for the product/shop sidebar 
 * @use - in wp_dasboard > appearance > Widgets > "Product Sidebar" apply any custom HTML or widget to display on product/shop sidebar section.  
 *  
 */
add_shortcode( 'product-sidebar', 'product_sidebar' );
function product_sidebar(){ ob_start(); do_shortcode(dynamic_sidebar("product-sidebar-widget"));  return ob_get_clean(); }

/** 
 *
 * function:dump($param)
 * @return any - display result of output in readable format.
 * @desc - this func also can use to debug a script or inspect the output of a result  
 *  
 */
function dump($d){ echo('<pre>'); var_dump($d); echo('</pre>'); }

?>